import { Sparkles, Mail, Phone, MapPin, Clock, Facebook, Instagram, Twitter } from 'lucide-react'
import './Footer.css'

function Footer() {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Sparkles size={32} strokeWidth={2.5} className="footer-logo-icon" />
              <h2 className="footer-logo-text">CostumeRent</h2>
            </div>
            <p className="footer-description">
              Премиальная аренда костюмов для любых мероприятий. 
              Превратите свой праздник в незабываемое событие.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link">
                <Facebook size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Instagram size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Twitter size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Навигация</h3>
            <ul className="footer-links">
              <li><a href="/">Мои аренды</a></li>
              <li><a href="/rent">Арендовать</a></li>
              <li><a href="#">Каталог</a></li>
              <li><a href="#">О нас</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={18} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={18} strokeWidth={2} />
                <a href="mailto:info@costumerent.ru">info@costumerent.ru</a>
              </li>
              <li>
                <MapPin size={18} strokeWidth={2} />
                <span>Москва, ул. Костюмная, 10</span>
              </li>
              <li>
                <Clock size={18} strokeWidth={2} />
                <span>Пн-Вс: 10:00 - 22:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 CostumeRent. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

